﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Graphics;
using CashierCrisis.Managers;
using Microsoft.Xna.Framework;

namespace CashierCrisis.UserInterface
{
    public class MainMenuUI : UI
    {
        InputManager input;
        UIButton playButton;
        UIButton helpButton;
        UIButton exitButton;
    
    

        public MainMenuUI(Game game):base(game)
        {
            FontManager fontManager = CashierGame.Instance.Services.GetService(typeof(FontManager)) as FontManager;
            SpriteFont font = fontManager.GetFont("Default");
            input = CashierGame.Instance.Services.GetService(typeof(InputManager)) as InputManager;
           
            playButton =  new UIButton("Play",Color.Yellow);
            playButton.Font = font;
            playButton.Position = new Microsoft.Xna.Framework.Vector2(SceneManager.RightAlign, 400);
            playButton.Visible = true;

            helpButton = new UIButton("Help", Color.Yellow);
            helpButton.Font = font;
            helpButton.Position = new Microsoft.Xna.Framework.Vector2(SceneManager.RightAlign, 450);
            helpButton.Visible = true;
            
            exitButton = new UIButton("Exit", Color.Yellow);
            exitButton.Font = font;
            exitButton.Position = new Microsoft.Xna.Framework.Vector2(SceneManager.RightAlign, 500);
            exitButton.Visible = true;

            AddWidget(playButton);
            AddWidget(helpButton);
            AddWidget(exitButton);
        }

        public override void WidgetCallback(UIWidget widget)
        {
            if (widget == playButton)
            {
               SceneManager.ChangeScene("Play");
               UIManager.PopUserInterface();
 
            }

            if (widget == helpButton)
            {
                SceneManager.ChangeScene("Help");
                UIManager.PopUserInterface();
                UIManager.PushUserInterface("Help");
                
            }

            if (widget == exitButton)
            {
                UIManager.SwapUserInterface("Exit");
            }
        }

        public override void Update(Microsoft.Xna.Framework.GameTime gameTime)
        {
            base.Update(gameTime);
       
            if (input.UpButton())
            {
                NextWidget();
            }

            if (input.DownButton())
            {
                PreviousWidget();
            }

            if (input.ConfirmButton())
            {
                IButton button = (IButton)SelectedWidget();
                button.OnPressed();
            }
            
        }
      
    }
}
